# Concentrations of heavy metals in European agricultural soils, Oct. 2020

This data set contains current and critical metal concentrations and its exceedances in topsoils, as well as data related to the current and critical metal inputs to and outputs from soils (uptake, accumulation and leaching) and the resulting exceedances of critical metal inputs. 

This data set has been compiled by the European Topic Centre on Urban, Land and Soil Systems (ETC/ULS) in the context of a study on metal and nutrient dynamics where the fate and dynamics of the most abundant heavy metals and nutrients in agricultural soils were investigated. The purpose of this study was to investigate the impacts of agricultural intensification in Europe, and to understand its environmental impact. Metal concentrations in soils were used from two consecutive Europe-wide geochemical surveys, sampled in 1998 (FOREGS survey) and 2009 (GEMAS survey). For land use, the 2010 Eurostat data were used. 

The metals included in this data set are cadmium (Cd), copper (Cu), lead (Pb) and zinc (Zn). The results on the fate of Nitrogen (N) and Phosphorus (P) are included in a separate dataset. Cu and Zn are minor nutrients but at high inputs, they may cause adverse impacts on soil biodiversity, whereas Cd and Pb are toxic metals that may lead to soil degradation, by both affecting soil biodiversity and food quality. Metal budgets based on spatially explicit input and output data were calculated using the INTEGRATOR model; approximately 40,000 so-called NCUs as unique combinations of soil type, administrative region, slope class and altitude class were used. Available critical limits for food, water and soil organisms, from different existing regulations and studies, were converted to soil property-dependent critical metal concentrations (soil-based quality standards), which were then used to calculate critical metal inputs. 

The results allow for the first time to identifying spatial hot spots for critical environmental impact of soil pollution for the four most abundant heavy metals. It thus informs policy processes important for planning and guiding sustainable agriculture and soil management. The work is methodologically novel, as it applies endpoint risk to thresholds in soils, and thus guides future impact studies. Updates with more recent land use and soil data are now possible.

The description of the included model results and the reference report is provided under "lineage". The data set is provided as SHP and also in a GDB, the latter including as well the N and P concentrations. An Excel file "Metadata heavy metals nutrients.xlsx" with the attribute metadata is provided with the data set.https://sdi.eea.europa.eu/geonetwork/srv/api/records/f23391fd-2524-42be-91cb-27d930d6a099


[More information](https://sdi.eea.europa.eu/catalogue/srv/api/records/f23391fd-2524-42be-91cb-27d930d6a099)
    