#!/bin/sh
# Rasterize CLC v16, from ArcGIS v10 file geodatabase
# Hermannn, April 2012

FGDB=download/clc2006_rel16.gdb

OUTDIR=outfiles
LEGEND="'clc_legend.csv'.clc_legend"

# Loop through layer_code.list
awk '! /^#/' layer_code.list | while read LAYER CODE RES; do

        # Rasterize layer as out.tif
        gdal_rasterize $FGDB out.tif \
                -sql "select * from $LAYER left join $LEGEND on $CODE = CLC_CODE" \
                -te 1500000 900000 7400000 5500000 -tr $RES $RES \
                -ot byte -a GRID_CODE -a_nodata 0 \
                -co compress=deflate -co tiled=yes

        # Apply CLC color table
        gdal_translate legend_$RES.vrt $OUTDIR/${LAYER}_${CODE}_${RES}.tif \
                -co compress=deflate -co tiled=yes

        # Remove tmp file
        rm -f out.tif
done

exit 0
